import turtle, math

DRAW_FRACTAL = 1 # Wybierz liczbę z przedziału od 1 do 11 i uruchom program

turtle.tracer(5000, 0) # Zwiększ pierwszy argument, aby przyspieszyć rysowanie
turtle.hideturtle()

def drawFilledSquare(size, depth):
    size = int(size)
    
    # Przed rozpoczęciem rysowania przesuwam żółwia do prawego górnego rogu
    turtle.penup()
    turtle.forward(size // 2)
    turtle.left(90)
    turtle.forward(size // 2)
    turtle.left(180)
    turtle.pendown()

    # Stosuję na przemian biały i szary kolor (kontury rysuję na czarno):
    if depth % 2 == 0:
        turtle.pencolor('black')
        turtle.fillcolor('white')
    else:
        turtle.pencolor('black')
        turtle.fillcolor('gray')

    # Rysowanie kwadratu:
    turtle.begin_fill()
    for i in range(4): # Rysowanie czterech linii
        turtle.forward(size)
        turtle.right(90)
    turtle.end_fill()


def drawTriangleOutline(size, depth):
    size = int(size)

    # Przesuwam żółwia na szczyt trójkąta równobocznego:
    height = size * math.sqrt(3) / 2
    turtle.penup()
    turtle.left(90) # Zmieniam kierunek żółwia na północ
    turtle.forward(height * (2/3)) # Przesuwam żółwia do górnego rogu
    turtle.right(150) # Obracam żółwia tak, aby wskazywał prawy dolny róg
    turtle.pendown()

    # Rysuję trzy boki trójkąta:
    for i in range(3):
        turtle.forward(size)
        turtle.right(120)


def drawFractal(shapeDrawFunction, size, specs, maxDepth=8, depth=0):
    if depth > maxDepth or size < 1:
        return # PRZYPADEK BAZOWY

    # Na początku tego wywołania zapamiętuję położenie żółwia i jego kierunek:
    initialX = turtle.xcor()
    initialY = turtle.ycor()
    initialHeading = turtle.heading()

    # Wywołuję funkcję shapeDrawFunction, aby narysować kształt:
    turtle.pendown()
    shapeDrawFunction(size, depth)
    turtle.penup()

    # PRZYPADEK REKURENCYJNY
    for spec in specs:
        # Każdy słownik ze specs zawiera klucze 'sizeChange', 'xChange',
        # 'yChange' oraz 'angleChange'. Zmiany rozmiaru, x i y są mnożone
        # przez wartość parametru size. Zmiany w osi x i y (xCh i yCh)
        # są dodawane do aktualnej pozycji żółwia. Zmiana kąta (angleCh)
        # jest dodawana do aktualnego kierunku żółwia.

        sizeCh = spec.get('sizeChange', 1.0)
        xCh = spec.get('xChange', 0.0)
        yCh = spec.get('yChange', 0.0)
        angleCh = spec.get('angleChange', 0.0)

        # Przeniesienie żółwia do punktu z początku wywołania funkcji.
        turtle.goto(initialX, initialY)
        turtle.setheading(initialHeading + angleCh)
        turtle.forward(size * xCh)
        turtle.left(90)
        turtle.forward(size * yCh)
        turtle.right(90)

        # Wywołanie rekurencyjne:
        drawFractal(shapeDrawFunction, size * sizeCh, specs, maxDepth,
        depth + 1)


if DRAW_FRACTAL == 1:
    # Cztery rogi:
    drawFractal(drawFilledSquare, 350,
        [{'sizeChange': 0.5, 'xChange': -0.5, 'yChange': 0.5},
         {'sizeChange': 0.5, 'xChange': 0.5, 'yChange': 0.5},
         {'sizeChange': 0.5, 'xChange': -0.5, 'yChange': -0.5},
         {'sizeChange': 0.5, 'xChange': 0.5, 'yChange': -0.5}], 5)
elif DRAW_FRACTAL == 2:
    # Spirala kwadratów:
    drawFractal(drawFilledSquare, 600, [{'sizeChange': 0.95,
        'angleChange': 7}], 50)
elif DRAW_FRACTAL == 3:
    # Podwójna spirala kwadratów:
    drawFractal(drawFilledSquare, 600,
        [{'sizeChange': 0.8, 'yChange': 0.1, 'angleChange': -10},
         {'sizeChange': 0.8, 'yChange': -0.1, 'angleChange': 10}])
elif DRAW_FRACTAL == 4:
    # Spirala trójkątów:
    drawFractal(drawTriangleOutline, 20,
        [{'sizeChange': 1.05, 'angleChange': 7}], 80)
elif DRAW_FRACTAL == 5:
    # Glider z „gry w życie” Conwaya:
    third = 1 / 3
    drawFractal(drawFilledSquare, 600,
        [{'sizeChange': third, 'yChange': third},
         {'sizeChange': third, 'xChange': third},
         {'sizeChange': third, 'xChange': third, 'yChange': -third},
         {'sizeChange': third, 'yChange': -third},
         {'sizeChange': third, 'xChange': -third, 'yChange': -third}])
elif DRAW_FRACTAL == 6:
    # Trójkąt Sierpińskiego:
    toMid = math.sqrt(3) / 6
    drawFractal(drawTriangleOutline, 600,
        [{'sizeChange': 0.5, 'yChange': toMid, 'angleChange': 0},
         {'sizeChange': 0.5, 'yChange': toMid, 'angleChange': 120},
         {'sizeChange': 0.5, 'yChange': toMid, 'angleChange': 240}])
elif DRAW_FRACTAL == 7:
    # Fala:
    drawFractal(drawTriangleOutline, 280,
        [{'sizeChange': 0.5, 'xChange': -0.5, 'yChange': 0.5},
         {'sizeChange': 0.3, 'xChange': 0.5, 'yChange': 0.5},
         {'sizeChange': 0.5, 'yChange': -0.7, 'angleChange': 15}])
elif DRAW_FRACTAL == 8:
    # Róg:
    drawFractal(drawFilledSquare, 100,
        [{'sizeChange': 0.96, 'yChange': 0.5, 'angleChange': 11}], 100)
elif DRAW_FRACTAL == 9:
    # Płatek śniegu:
    drawFractal(drawFilledSquare, 200,
        [{'xChange': math.cos(0 * math.pi / 180),
          'yChange': math.sin(0 * math.pi / 180), 'sizeChange': 0.4},
         {'xChange': math.cos(72 * math.pi / 180),
          'yChange': math.sin(72 * math.pi / 180), 'sizeChange': 0.4},
         {'xChange': math.cos(144 * math.pi / 180),
          'yChange': math.sin(144 * math.pi / 180), 'sizeChange': 0.4},
         {'xChange': math.cos(216 * math.pi / 180),
          'yChange': math.sin(216 * math.pi / 180), 'sizeChange': 0.4},
         {'xChange': math.cos(288 * math.pi / 180),
          'yChange': math.sin(288 * math.pi / 180), 'sizeChange': 0.4}])
elif DRAW_FRACTAL == 10:
    # Wypełniony kwadrat:
    turtle.tracer(1, 0)
    drawFilledSquare(400, 0)
elif DRAW_FRACTAL == 11:
    # Kontury trójkąta:
    turtle.tracer(1, 0)
    drawTriangleOutline(400, 0)
else:
    assert False, 'Ustaw wartość DRAW_FRACTAL na liczbę z przedziału od 1 do 11.'

turtle.exitonclick() # Kliknij w okno, aby zakończyć
